//CTF_Gamerules.c - routines dealing with detecting end of play/match

#include "g_local.h"

//for standard openplay with capture limit
int CTFRules(void)
{
	if(!maxcaptures->value)
		return 0;
	if(CTFGame.teamscore[0] >= maxcaptures->value)
		return 1;
	else
		if(CTFGame.teamscore[1] >= maxcaptures->value)
			return 2;
	return 0;
}

int CheckCTFRules(void)
{
	int Result;

	Result = CTFRules();
	if(Result)
	{
		gi.bprintf(PRINT_HIGH, "Capture limit reached. %s win the game.\n", team_names[Result]);
	}
	return Result;
}

//for match frag limit
int CTFMatchFragRules(void)
{
	int Team1Frags;
	int Team2Frags;
	int Count;
	edict_t* ent;
	
	Team1Frags = 0;
	Team2Frags = 0;
	for(Count=0;Count<game.maxclients;Count++)
	{
		ent = g_edicts + 1 + Count;
		if(!ent)
			continue;
		if(!ent->inuse)
			continue;
		if(ent->client->pers.team == 1)
//			Team1Frags = Team1Frags + ent->client->resp.PlayerData.Frags;
			Team1Frags = Team1Frags + ent->client->resp.score;
		else
			if(ent->client->pers.team == 2)
//				Team2Frags = Team2Frags + ent->client->resp.PlayerData.Frags;
				Team2Frags = Team2Frags + ent->client->resp.score;
	}
	if(Team1Frags >= fraglimit->value)
		return 1;
	else
		if(Team2Frags >= fraglimit->value)
			return 2;
	return 0;
}

int CheckCTFMatchFragRules(void)
{
	int Result;

	Result = CTFMatchFragRules();
	if(Result)
	{
		gi.bprintf(PRINT_HIGH, "Fraglimit reached. %s win the game.\n", team_names[Result]);
	}
	return Result;
}

